function RNAView(){
	var sequences = null;
	var cy = window.cy = cytoscape({
		container: document.getElementById('cy'),
		wheelSensitivity: 0.4,

		layout: {
			name: 'circle',
			startAngle: 1 * Math.PI,
			radius: 0.5
		},

		style: [
		
			{
				selector: 'node',
				css: {
					"content": "data(name)",
					"text-valign" : "center",
					"text-halign" : "center",
				}
			},
		
			{
				selector: 'edge.raw',
				css: {
					"width": 4,
					"line-color": "black"
				}
			},
							
			{
			selector: 'edge.soft',
				css: {
					"width": 3,
					"line-color": "#8A8A8A"
				}
			}
		]
	});
	
	this.createNewGraph = function(header, _sequences){
		cy.$('node').remove();
		cy.$('edge').remove();
		sequences = _sequences;
		sequencesInOrder = makeSequencesInOrder(header);
		arrayID = createBacisGraphInCircle(sequencesInOrder, header);
		joinNodesInCircle(arrayID);
		joinNodesInPair(sequencesInOrder, header);
		setLayout();
	}
	
	function createBacisGraphInCircle(sequencesInOrder, header){
		var arrayID = [];
		for(var i = 0; i < sequencesInOrder.length; i++){
			var n = header[i];
			var classTag = header[i].replace("'", "");
			var seqTag = header[i].replace("'", "-");
			var col = sequences[header[i]].getColor();
			var fCol = sequences[header[i]].getFontColor();
			var peaks = 0;
			for(var j = 0; j < sequencesInOrder[i].length; j++){
				var letter = changeAsterisk(sequencesInOrder[i][j]);
				var idName = header[i].replace("'", "-");
				idName = idName + letter + peaks;
				var n = sequencesInOrder[i][j];
				arrayID.push(idName);
				cy.add([
					{ group: "nodes", data: { id: idName, name: n, sequence:  seqTag}, classes: classTag},
				]);
				peaks++;
			}
			setColor(classTag, col, fCol);
		}
		cy.style().update();
		return arrayID;
	}
	
	function joinNodesInCircle(arrayID){
		var edgeID = 0;
		for(var i = 0; i < arrayID.length-1; i++){
			var id1 = arrayID[i];
			var id2 = arrayID[i+1];
			cy.add([
				{ group: "edges", data: { id: "ex" + edgeID, source: id1, target: id2}, classes: "raw"},
			]);
			edgeID++;
		}
	}
	
	function joinNodesInPair(sequencesInOrder, header){
		var visited = new Set();
		for(var i = 0; i < header.length; i++){
			if((header[i][0] === "h" || header[i][0] === "r") && !visited.has(header[i])){
				var index1 = i;
				var index2 = header.indexOf(header[i] + "'"); 
				visited.add(header[i]);
				visited.add(header[i] + "'");
				seq1 = sequencesInOrder[index1];
				seq2 = sequencesInOrder[index2];
				joinNodes(seq1, seq2, header[i]);
			}
		}
	}
	
	function setLayout(r){
		cy.layout({ name: 'circle',
				startAngle: 1 * Math.PI,
				radius: 1
		});
		cy.layout({ name: 'cola',
					avoidOverlap: false,
					edgeLength: 35,
					maxSimulationTime: 1000
		});
	}
	
	function joinNodes(seq1, seq2, header){
		for(var i = 0; i < seq1.length; i++){
			var j = seq1.length - 1 - i;
			var letter1 = changeAsterisk(seq1[i]);
			var letter2 = changeAsterisk(seq2[j]);
			var id1 = header + letter1 + i;
			var id2 = header + "-" + letter2 + j;
			var node1 = cy.$("#" + id1);
			var node2 = cy.$("#" + id2);
			cy.add([
				{ group: "edges", data: { id: header + i, source: id1, target: id2}, classes: "soft"},
			]);
		}
	}
	
	// Help functions  ===================================================================================
	function changeAsterisk(chracter){
		if(chracter === "*"){
			return "."
		}
		chracter = chracter.replace("[", "I");
		chracter = chracter.replace("]", "I");
		return chracter;
	}
	
	
	function makeSequencesInOrder(header){
		var result = [];
		for(var i = 0; i < header.length; i++){
			result[i] = [];
			pattern = sequences[header[i]].getPattern();
			pattern = cutPattern(pattern);
			for(var j = 0; j < pattern.length; j++){
				result[i].push(pattern[j]);
			}
		}
		return result;
	}
	
	function cutPattern(pattern){
		var result = [];
		var minString = "";
		for(var i = 0; i < pattern.length; i++){
			if(pattern[i] === "["){
				minString += pattern[i];
			}else if(pattern[i] === "]"){
				minString += pattern[i];
				result.push(minString);
				minString = "";
			}else if(minString !== ""){
				minString += pattern[i];
			}else{
				result.push(pattern[i]);
			}
		}
		return result;
	}
	
	// Create Image ===================================================================
	this.getImage = function(jpg){
		if(jpg === false){
			return cy.png();
		}else{
			return cy.jpg();
		}
	}
	
	// Colors ==========================================================================
	this.setColorInView = function(classTag, col, fCol){
		classTag = classTag.replace("-", "");
		setColor(classTag, col, fCol);
		cy.style().update();
	}
	
	function setColor(classTag, col, fCol){
		cy.style()
		  .selector('.'+ classTag)
			.style({
			  'background-color': col,
			  'color' : fCol
		});
	}
	
	// Resize ===========================================================================
	$(window).on('resize', function(){
		cy.resize();
	});	
}

